(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21520,        678]
NotebookOptionsPosition[     20340,        635]
NotebookOutlinePosition[     20735,        652]
CellTagsIndexPosition[     20692,        649]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
.NET/Link Example: Controlling Excel
\
\>", "Title"],

Cell[TextData[{
 StyleBox["This example demonstrates calling a COM object from ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" using .NET/Link. The COM object used is the Microsoft Excel \
application, and of course you must have Excel installed for this to work. \
You do not need to have a very recent version of Excel--this will probably \
work for at least as far back as Excel 97.\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\n.NET/Link allows you to control COM objects via their ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["I",
  FontSize->12,
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Dispatch",
  FontSize->12,
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" interface, otherwise known as ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["ActiveX Automation",
  FontSize->12,
  FontWeight->"Bold",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", or just Automation. This means that the same sorts of things \
that can be done with scripting languages like Visual Basic and VBScript can \
be done in ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[". ",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 "Microsoft Excel is a good example of an application that exposes a very \
complete and useful object model to Automation. If you have ever programmed \
in Excel\[CloseCurlyQuote]s Visual Basic for Applications (VBA), you know \
that everything that can be done in Excel can be done from VBA. ",
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 " can use the same Automation services that VBA uses, and so it is equally \
powerful. As can be seen by looking at the code, it is also as easy to \
program these tasks in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " as it is in Visual Basic.",
 StyleBox["\n",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["\nThis example presents a function called ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["ExcelPieChart", "Input",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[", which produces a pie chart in Excel as its output.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Text",
 FontFamily->"Arial"],

Cell[CellGroupData[{

Cell["Code and Explanation", "Section"],

Cell[TextData[{
 "The following cell compares two programs that create a simple pie chart in \
Excel. The code on the left is the Visual Basic for Applications code that \
you would write if you were working within Excel. The code on the right is a \
",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " program that does the same thing. You can see that these two programs are \
essentially identical. Note only does .NET/Link give you the same power as \
Visual Basic, it provides the same convenience to the programmer."
}], "Text"],

Cell[TextData[Cell[BoxData[GridBox[{
   {
    RowBox[{
     RowBox[{"Visual", " ", "Basic"}], "\[IndentingNewLine]", 
     "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{
       RowBox[{"Set", " ", "wb"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"Application", ".", "Workbooks"}], 
        RowBox[{"(", "1", ")"}]}]}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"Set", " ", "ws"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"wb", ".", "Worksheets"}], 
        RowBox[{"(", "1", ")"}]}]}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"A1\"\>", ")"}], ".", "Value"}]}], " ", "=", 
       " ", "\<\"North\"\>"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"A2\"\>", ")"}], ".", "Value"}]}], " ", "=", 
       " ", "\<\"South\"\>"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"A3\"\>", ")"}], ".", "Value"}]}], " ", "=", 
       " ", "\<\"East\"\>"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"A4\"\>", ")"}], ".", "Value"}]}], " ", "=", 
       " ", "\<\"West\"\>"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"B1\"\>", ")"}], ".", "Value"}]}], " ", "=", " ", 
       "5.2"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"B2\"\>", ")"}], ".", "Value"}]}], " ", "=", " ", 
       "10"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"B3\"\>", ")"}], ".", "Value"}]}], " ", "=", " ", 
       "8"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{
         RowBox[{"(", "\<\"B4\"\>", ")"}], ".", "Value"}]}], " ", "=", " ", 
       "20"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"Set", " ", "sourceRange"}], " ", "=", " ", 
       RowBox[{
        RowBox[{"ws", ".", "Range"}], 
        RowBox[{"(", "\<\"A1:B4\"\>", ")"}]}]}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"Set", " ", "chrt"}], " ", "=", " ", 
       RowBox[{"wb", ".", "Charts", ".", "Add"}]}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"chrt", ".", "ChartWizard"}], " ", "sourceRange"}], ",", " ", 
       "xl3DPie", ",", " ", "7", ",", " ", "xlColumns", ",", 
       "\[IndentingNewLine]", "\t\t ", "1", ",", " ", "0", ",", " ", "2", ",",
        " ", "\<\"Sales Percentages\"\>"}],
      FontSize->12,
      FontWeight->"Normal"]}], 
    RowBox[{"Mathematica", "\[IndentingNewLine]", "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{
       RowBox[{"wb", "=", 
        RowBox[{"excel", "@", 
         RowBox[{"Workbooks", "@", 
          RowBox[{"Item", "[", "1", "]"}]}]}]}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"ws", "=", 
        RowBox[{"wb", "@", 
         RowBox[{"Worksheets", "@", 
          RowBox[{"Item", "[", "1", "]"}]}]}]}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"A1\"\>", "]"}], "@", "Value"}]}], 
        "=", "\<\"North\"\>"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"A2\"\>", "]"}], "@", "Value"}]}], 
        "=", "\<\"South\"\>"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"A3\"\>", "]"}], "@", "Value"}]}], 
        "=", "\<\"East\"\>"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"A4\"\>", "]"}], "@", "Value"}]}], 
        "=", "\<\"West\"\>"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"B1\"\>", "]"}], "@", "Value"}]}], "=", 
        "5.2"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"B2\"\>", "]"}], "@", "Value"}]}], "=", 
        "10"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"B3\"\>", "]"}], "@", "Value"}]}], "=", 
        "8"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{
        RowBox[{"ws", "@", 
         RowBox[{
          RowBox[{"Range", "[", "\<\"B4\"\>", "]"}], "@", "Value"}]}], "=", 
        "20"}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"srcRange", "=", 
        RowBox[{"ws", "@", 
         RowBox[{"Range", "[", "\<\"A1:B4\"\>", "]"}]}]}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"chrt", "=", 
        RowBox[{"wb", "@", 
         RowBox[{"Charts", "@", "Add"}]}]}], ";"}],
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox["\n",
      FontSize->12,
      FontWeight->"Normal"], 
     StyleBox[
      RowBox[{
       RowBox[{"chrt", "@", 
        RowBox[{"ChartWizard", "[", 
         RowBox[{"srcRange", ",", 
          RowBox[{"-", "4102"}], ",", "7", ",", "2", ",", 
          "\[IndentingNewLine]", "\t\t", "1", ",", "0", ",", "2", 
          ",", "\<\"Sales Percentages\"\>"}], "]"}]}], ";"}],
      FontSize->12,
      FontWeight->"Normal"]}]}
  }]]]], "Input",
 Evaluatable->False,
 Background->GrayLevel[0.900008]],

Cell["\<\
The ExcelPieChart program developed below is a slightly generalized version \
of the example code in the above cell.\
\>", "Text"],

Cell["\<\
Needs[\"NETLink`\"]

ExcelPieChart[{labels:{__String}, values:{__?NumberQ}}, title_String] :=
\tModule[{excel, wb, ws},
\t\tNETBlock[
\t\t\tInstallNET[];
\t\t\t(* We use CreateCOMObject to launch an instance of Excel. It will not \
be visible until
\t\t\t   we make it so at the end of the program. Use GetActiveCOMObject \
instead of CreateCOMObject
\t\t\t   if you want to attach to a currently-running instance of Excel \
instead of launching a new one.
\t\t\t   The argument to CreateCOMObject is a COM ProgID or CLSID (most users \
will use the ProgID,
\t\t\t   which is readable text, like \"Excel.Application\". The excel object \
returned is a .NET
\t\t\t   object that \"wraps\" a COM object and makes it look like a .NET \
object to callers.
\t\t\t*)
\t\t\texcel = CreateCOMObject[\"Excel.Application\"];
\t\t\tIf[!NETObjectQ[excel],
\t\t\t\tReturn[$Failed]
\t\t\t];
\t\t\t
\t\t\t(* Now we begin working with the excel COM object. Consult Excel's \
documentation for its object
\t\t\t   model to see what properties and methods are supported and how to \
use them.
\t\t\t*)
\t\t\twb = excel@Workbooks@Add[];
\t\t\tws = wb@Worksheets@Item[1];
\t\t\t
\t\t\t(* Here we fill the range A1 ... An with the pie slice labels. *)
\t\t\tMapThread[(ws@Range[#1]@Value = #2)&,
\t\t\t\t{Table[\"A\" <> ToString[i], {i, Length[labels]}], labels}
\t\t\t];
\t\t\t(* Here we fill the range B1 ... Bn with the values the control the \
slice sizes. *)
\t\t\tMapThread[(ws@Range[#1]@Value = #2)&,
\t\t\t\t{Table[\"B\" <> ToString[i], {i, Length[values]}], values}
\t\t\t];
\t\t\tsrcRange = ws@Range[\"A1:\" <> \"B\" <> ToString[Length[values]]];
\t\t\t
\t\t\t(* Now create a new Chart object and call the ChartWizard to build the \
chart. *)
\t\t\tchrt = wb@Charts@Add[];
\t\t\tchrt@ChartWizard[srcRange, -4102, 7, 2, 1, 0, 2, title];
\t\t\t
\t\t\t(* This makes the Excel application visible. *)
\t\t\texcel@Visible = True;
\t\t];
\t\t
\t\t(* The Excel instance we launched will not quit until all the COM \
resources that are being held by
\t\t   .NET objects we created are released. .NET/Link provides a function \
called ReleaseCOMObject that
\t\t   can be used to force .NET objects that \"wrap\" COM objects to release \
those COM objects. We could,
\t\t   for example, call ReleaseCOMObject[excel] here, but that is not enough \
because we have created
\t\t   many COM objects (Range objects, for example). Rather that try to keep \
track of them all and call
\t\t   ReleaseCOMObject on every one, it's easier to rely on the fact that \
COM resources are freed when
\t\t   their .NET wrapper objects are freed by the garbage collector. \
Therefore we use a NETBlock to
\t\t   ensure that all objects are marked for release when the NETBlock ends, \
and then explictly call
\t\t   the garbage collector to force the objects to be freed in a timely \
manner.
\t\t*)
\t\tLoadNETType[\"System.GC\"];
\t\tGC`Collect[];
\t]\
\>", "Input",
 InitializationCell->True],

Cell[CellGroupData[{

Cell["Interop Assembles", "Subsection"],

Cell[TextData[{
 ".NET/Link can work with \"raw\" COM objects or COM objects that have a \
so-called \"interop assembly\" created from them. The Microsoft .NET \
Framework SDK includes a tool called tlbimp.exe that you can use to import a \
COM type library and spit out a .NET assembly that exposes the COM types in \
the library as .NET objects. The .NET SDK is freely availablefrom Microsoft, \
but it is a separate download from the .NET Framework runtime, which is all \
that you need to run, but not actually compile, .NET programs. Although \
creating an interop assembly from a COM type library is not necessary to use \
the COM objects in the library from ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", it is recommended if you are doing serious work. (Note that essentially \
the same functionality provided by the command-line tool tlbimp.exe is \
provided by the .NET/Link ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 StyleBox["LoadCOMTypeLibrary",
  FontWeight->"Bold"],
 ". You can use that function to create and load an interop assembly \"on the \
fly\" without getting the .NET SDK.)"
}], "Text"],

Cell[TextData[{
 "Some interop assemblies are specially designated as \"primary interop \
assemblies\", or PIAs. Typically, the vendor of the COM type library will \
provide a PIA for that type library. PIAs are strongly-named assemblies and \
can be installed in the Global Assembly Cache. Microsoft makes PIAs available \
for the entire Office XP suite, and anyone working with Office XP using \
.NET/Link should definitely obtain and install them. A good place to start is \
this link: ",
 ButtonBox["http://msdn.microsoft.com/library/default.asp?url=/library/en-us/\
dnoxpta/html/odc_oxppias.asp",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    URL["http://msdn.microsoft.com/library/default.asp?url=/library/en-us/\
dnoxpta/html/odc_oxppias.asp"], None}],
 "."
}], "Text"],

Cell[TextData[{
 "Once you have created or obtained an interop assembly, you load it and use \
it in .NET/Link like any other assembly. Two advantages of using an interop \
assembly are: (1) The types can be inspected just like other native .NET \
types using the .NET/Link ",
 StyleBox["NETTypeInfo",
  FontWeight->"Bold"],
 " function, and (2) You can get access to constants and COM events defined \
in the type library. You may have noticed the cryptic constants in the \
chart@ChartWizard[] call in the ExcelPieChart program, vs. the descriptive \
names xl3DPie and xlColumns in the Visual Basic for Applications version. You \
can discover the values of these constants in VBA by executing, for example, \
?xl3DPie in the Immediate window of the Excel Visual Basic Editor. But if you \
have installed the Excel PIA, these constants are available by name. This \
means that you could use the following code:"
}], "Text"],

Cell["\<\
\tLoadNETType[\"Microsoft.Office.Interop.Excel.XlChartType\"];
\tchrt@ChartWizard[srcRange, XlChartType`xl3DPie, 7, 2, 1, 0, 2, title]\
\>", "Input"],

Cell[TextData[{
 "How did I know that the xl3DPie constant was in an enumeration called \
Microsoft.Office.Interop.Excel.xlChartType? I used ",
 StyleBox["NETTypeInfo",
  FontWeight->"Bold"],
 " on the interop assembly object and did some guesswork from there. \
Unfortunately, there is not yet much documentation on the Office PIAs. I \
never did find out where the xlColumn constant is defined."
}], "Text"],

Cell[TextData[{
 "If you have a PIA installed for a given COM object, then .NET/Link will \
automatically return the correct .NET object from that PIA when you call ",
 StyleBox["CreateCOMObject",
  FontWeight->"Bold"],
 " or ",
 StyleBox["GetActiveCOMObject",
  FontWeight->"Bold"],
 "."
}], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
data = {{\"label1\", \"label2\", \"label3\", \"label4\"}, {45, 15, 30, 10}};\
\>", "Input",
 InitializationCell->True],

Cell["This will launch Excel and make the chart appear:", "Text"],

Cell["ExcelPieChart[data, \"Chart Title\"]", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{1025, 665},
WindowMargins->{{1, Automatic}, {Automatic, -1}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 62, 3, 123, "Title"],
Cell[655, 28, 3388, 96, 215, "Text"],
Cell[CellGroupData[{
Cell[4068, 128, 39, 0, 67, "Section"],
Cell[4110, 130, 537, 10, 71, "Text"],
Cell[4650, 142, 8424, 303, 345, "Input",
 Evaluatable->False],
Cell[13077, 447, 140, 3, 33, "Text"],
Cell[13220, 452, 2966, 76, 1002, "Input",
 InitializationCell->True],
Cell[CellGroupData[{
Cell[16211, 532, 39, 0, 38, "Subsection"],
Cell[16253, 534, 1145, 22, 128, "Text"],
Cell[17401, 558, 776, 15, 71, "Text"],
Cell[18180, 575, 925, 15, 109, "Text"],
Cell[19108, 592, 159, 3, 48, "Input"],
Cell[19270, 597, 409, 8, 52, "Text"],
Cell[19682, 607, 300, 9, 52, "Text"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20031, 622, 26, 0, 37, "Section"],
Cell[20060, 624, 128, 3, 24, "Input",
 InitializationCell->True],
Cell[20191, 629, 65, 0, 26, "Text"],
Cell[20259, 631, 53, 0, 24, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

